--[[
CMD Monster Hunting v1.1 (100710)
by DJ Command

http://cmdplus.tuzikaze.com/
http://www.s-a-r.jp/
dj-command@y3.dion.ne.jp
]]

---------------- Initial Values ----------------
Triggers, DEFPLGN = {}, {}
CollectionsUsed = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31}
Availables = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,43,44,45,46}
AvailablesWeapons = {"pistol","fusion pistol","assault rifle","flamethrower","shotgun","missile launcher","alien weapon","smg"}
TIMER = 300
RESTMONSTER = 0
------------------------------------------------

CNST_MSTRRELOAD = 240
CNST_MSTRINCRESE = 6 * #Players
CNST_TURNSPD = 3

--[[
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
•••••••••••••••••••••••••••• 関数定義 ••••••••••••••••••••••••••
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
]]

function INSTALL(M)
	if M.player == nil then ----モンスターならば
		if M.active == false then
			M.visible = false
		end
		M.active = true
		M._ID = M
		M._maxlife = M.life
		M._intlife = M.life
		M._diflife = M.life
	end
	
end

function CLEARITEMS()
	for I in Items() do
		if I.type ~= "invisibility" and I.type ~= "invincibility" and I.type ~= "infravision" and I.type ~= "extravision" and I.type ~= "oxygen" and I.type ~= "single health" and I.type ~= "double health" and I.type ~= "triple health" then
			I:delete()
		end
	end
end

function SETITEMS()
	for P in Players() do
		if P.dead == false then
			P.items["pistol ammo"]		= 50
			P.items["assault rifle ammo"]		= 15
			P.items["fusion pistol ammo"]		= 25
			P.items["assault rifle grenades"]	= 8
			P.items["missile launcher ammo"]	= 4
			P.items["smg ammo"]					= 8
			P.items["shotgun ammo"]				= 80
			P.items["alien weapon ammo"]		= 10
			P.items["flamethrower ammo"]		= 3
			P.items["uplink chip"]				= 80
			
			--P.items["fist"]						= 0
			P.items["pistol"]					= 0
			P.items["fusion pistol"]			= 0
			P.items["assault rifle"]			= 0
			P.items["shotgun"]					= 0
			P.items["missile launcher"]			= 0
			P.items["flamethrower"]				= 0	
			P.items["alien weapon"]				= 0
			P.items["smg"]						= 0
			
			P.items[P._possessitem[1]] = 1
			P.items[P._possessitem[2]] = 1
			P.items[P._possessitem[3]] = 1
		end
	end
end

function DEFINEMONSTERS()
	for M in Monsters() do
		if M._ID == nil or M._ID ~= M then ----照合IDが無いモンスター、もしくは照合が一致しないモンスターならば
			INSTALL(M)
		end
	end
end

function DEFINEPOLYGONS()
	for G in Polygons() do
		if G.type ~= "monster impassable" and G.type ~= "platform" then
			table.insert(DEFPLGN, G)
		end
	end
end

function STARTENEMYS()
	for M in Monsters() do
		INSTALL(M)
	end
end

function MONSTERGENERATE()
	local rnda, rndp, optP = 0, 0, {}
	
	if TIMER > CNST_MSTRRELOAD then
		TIMER = 0
		for i = 1, CNST_MSTRINCRESE do
			rnda = Game.global_random(#Availables) + 1
			optP = {}
			for i = 1, #DEFPLGN do
				if DEFPLGN[i].ceiling.z - DEFPLGN[i].floor.z > MonsterTypes[Availables[rnda]].height then
					table.insert(optP, DEFPLGN[i])
				end
			end
			if #optP ~= 0 then
				rndp = Game.global_random(#optP) + 1
				Monsters.new(optP[rndp].x, optP[rndp].y, optP[rndp].z, optP[rndp], Availables[rnda])
			end
		end
	else
		TIMER = TIMER + 1
	end
end

function PLAYERPROC()
	local j
	RESTMONSTER = 0
	for r in Monsters() do
		if r.player == nil then
			RESTMONSTER = RESTMONSTER + 1
		end
	end
	
	for P in Players() do
		P.overlays[0].color = 0
		P.overlays[0].text = "Your Score : " .. P.points
		P.overlays[1].color = 6
		P.overlays[1].text = "         Rest Enemys : " .. RESTMONSTER
		P._lockedtgt = P:find_target()
		if is_monster(P._lockedtgt) then
			if P._lockedtgt._ID ~= nil and P._lockedtgt._ID == P._lockedtgt then ----照合IDが付いたモンスターでかつ、照合が合致したモンスターならば
				P.overlays[2].color = 4
				P.overlays[2].text = "               " .. P._lockedtgt.type.mnemonic .. " : " .. P._lockedtgt._intlife
			end
		else
			P._lockedtgt = nil
			P.overlays[2].text = ""
		end
	end
end

--[[
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
•••••••••••••••••••••• AlephOne 内部イベント ••••••••••••••••••••
•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••
]]

function Triggers.monster_killed(M, agrs_P)								----＜モンスター死亡トリガー＞
	if M._ID ~= nil and M._ID == M then 								----照合IDが付いたモンスターでかつ、照合が合致したモンスターならば
		if agrs_P ~= nil then 											----プレイヤーがMを殺したならば
			agrs_P.points = agrs_P.points + M._maxlife					----点数に死亡したモンスターの最大エネルギーを加算
			agrs_P:play_sound("get item", 1.5)							----点数獲得音（テーン）
			agrs_P.life = agrs_P.life + M._maxlife / 10
		end
	end
end

function Triggers.monster_damaged(M, agrs_M, dmg_type, dmg, F)			----＜モンスター・ダメージトリガー＞
	local i
	if M._ID ~= nil and M._ID == M then 								----照合IDが付いたモンスターでかつ、照合が合致したモンスターならば
		
		if M.player == nil then
			M._intlife = M._intlife - dmg
			M.life = math.min(32767, M._intlife)
		end
		
		if agrs_M ~= nil and agrs_M.player then 						----攻撃した者がプレイヤーならば
			i = math.min(dmg, M._diflife)								----ダメージ量と前回記録したエネルギーを比較し、小さい方 = i
			M._diflife = M._intlife										----ダメージ記録を更新
			agrs_M.player.points = agrs_M.player.points + i				----点数にiを加算
		end
	end
end

function Triggers.player_damaged(P, agrs_P, agrs_M, dmg_type, dmg, F)	----＜プレイヤー・ダメージトリガー＞
	if agrs_P ~= nil and agrs_P ~= P then 								----攻撃者がプレイヤーでかつ、攻撃者がプレイヤー自身（＝自爆でない）でないならば
		P.life = P.life + dmg 											----ダメージを打ち消しにする
	end
end

function Triggers.init()
	local rnd = 0
	for P in Players() do
		P._possessitem = {}
		rnd = Game.global_random(#AvailablesWeapons) + 1
		table.insert(P._possessitem,  "missile launcher")
		
		rnd = Game.global_random(#AvailablesWeapons) + 1
		table.insert(P._possessitem, rnd)
		
		rnd = Game.global_random(#AvailablesWeapons) + 1
		table.insert(P._possessitem, rnd)
	end
	DEFINEPOLYGONS()
	STARTENEMYS()
end

function Triggers.idle()
	CLEARITEMS()
	SETITEMS()
	MONSTERGENERATE()
	DEFINEMONSTERS()
	PLAYERPROC()
end